/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedDocumentAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DlsFlsProcessedConfig {
    private static final Logger log = LogManager.getLogger(DlsFlsProcessedConfig.class);
    public static final DlsFlsProcessedConfig DEFAULT = new DlsFlsProcessedConfig(DlsFlsConfig.DEFAULT, null, null, null, null, null);
    private final DlsFlsConfig dlsFlsConfig;
    private final RoleBasedDocumentAuthorization documentAuthorization;
    private final RoleBasedFieldAuthorization fieldAuthorization;
    private final RoleBasedFieldMasking fieldMasking;
    private final boolean enabled;
    private final boolean validationErrorsPresent;
    private final String validationErrorDescription;
    private final String uniqueValidationErrorToken;

    DlsFlsProcessedConfig(DlsFlsConfig dlsFlsConfig, RoleBasedDocumentAuthorization documentAuthorization, RoleBasedFieldAuthorization fieldAuthorization, RoleBasedFieldMasking fieldMasking, ValidationErrors rolesValidationErrors, ValidationErrors rolesMappingValidationErrors) {
        this.dlsFlsConfig = dlsFlsConfig;
        this.documentAuthorization = documentAuthorization;
        this.fieldAuthorization = fieldAuthorization;
        this.fieldMasking = fieldMasking;
        this.enabled = dlsFlsConfig.getEnabledImpl() == DlsFlsConfig.Impl.FLX;
        this.validationErrorsPresent = rolesValidationErrors != null && rolesValidationErrors.hasErrors() || rolesMappingValidationErrors != null && rolesMappingValidationErrors.hasErrors();
        this.uniqueValidationErrorToken = UUID.randomUUID().toString();
        this.validationErrorDescription = this.describeValidationErrors(this.uniqueValidationErrorToken, rolesValidationErrors, rolesMappingValidationErrors);
    }

    static DlsFlsProcessedConfig createFrom(ConfigMap configMap, ComponentState componentState, Set<String> indices) {
        try {
            SgDynamicConfiguration dlsFlsConfigContainer = configMap.get(DlsFlsConfig.TYPE);
            DlsFlsConfig dlsFlsConfig = null;
            RoleBasedDocumentAuthorization documentAuthorization = null;
            RoleBasedFieldAuthorization fieldAuthorization = null;
            RoleBasedFieldMasking fieldMasking = null;
            dlsFlsConfig = dlsFlsConfigContainer != null && dlsFlsConfigContainer.getCEntry("default") != null ? (DlsFlsConfig)dlsFlsConfigContainer.getCEntry("default") : DlsFlsConfig.DEFAULT;
            SgDynamicConfiguration roleConfig = configMap.get(CType.ROLES);
            if (dlsFlsConfig.getEnabledImpl() == DlsFlsConfig.Impl.FLX) {
                documentAuthorization = new RoleBasedDocumentAuthorization((SgDynamicConfiguration<Role>)roleConfig, indices, dlsFlsConfig.getMetricsLevel());
                fieldAuthorization = new RoleBasedFieldAuthorization((SgDynamicConfiguration<Role>)roleConfig, indices, dlsFlsConfig.getMetricsLevel());
                fieldMasking = new RoleBasedFieldMasking((SgDynamicConfiguration<Role>)roleConfig, dlsFlsConfig.getFieldMasking(), indices, dlsFlsConfig.getMetricsLevel());
                if (log.isDebugEnabled()) {
                    log.debug("Using FLX DLS/FLS implementation\ndocumentAuthorization: " + documentAuthorization + "\nfieldAuthorization: " + fieldAuthorization + "\nfieldMasking: " + fieldMasking);
                }
                componentState.replacePart(documentAuthorization.getComponentState());
                componentState.replacePart(fieldAuthorization.getComponentState());
                componentState.replacePart(fieldMasking.getComponentState());
                componentState.setState(ComponentState.State.INITIALIZED);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("FLX DLS/FLS implementation is disabled");
                }
                componentState.setState(ComponentState.State.DISABLED);
            }
            ValidationErrors rolesValidationErrors = roleConfig.getValidationErrors();
            ValidationErrors rolesMappingsValidationErrors = Optional.ofNullable(configMap.get(CType.ROLESMAPPING)).map(SgDynamicConfiguration::getValidationErrors).orElse(null);
            return new DlsFlsProcessedConfig(dlsFlsConfig, documentAuthorization, fieldAuthorization, fieldMasking, rolesValidationErrors, rolesMappingsValidationErrors);
        }
        catch (Exception e) {
            log.error("Error while updating DLS/FLS config", (Throwable)e);
            componentState.setFailed((Throwable)e);
            return DEFAULT;
        }
    }

    public DlsFlsConfig getDlsFlsConfig() {
        return this.dlsFlsConfig;
    }

    public RoleBasedDocumentAuthorization getDocumentAuthorization() {
        return this.documentAuthorization;
    }

    public RoleBasedFieldAuthorization getFieldAuthorization() {
        return this.fieldAuthorization;
    }

    public RoleBasedFieldMasking getFieldMasking() {
        return this.fieldMasking;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MetricsLevel getMetricsLevel() {
        return this.dlsFlsConfig.getMetricsLevel();
    }

    public void updateIndices(Set<String> indices) {
        if (this.documentAuthorization != null) {
            this.documentAuthorization.updateIndices(indices);
        }
        if (this.fieldAuthorization != null) {
            this.fieldAuthorization.updateIndices(indices);
        }
        if (this.fieldMasking != null) {
            this.fieldMasking.updateIndices(indices);
        }
    }

    public boolean containsValidationError() {
        return this.validationErrorsPresent;
    }

    private static String describeConfigurationErrors(Map<String, Collection<ValidationError>> validationErrors, String configType) {
        if (validationErrors.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("The following validation errors found in SearchGuard ").append(configType).append(" definitions. ");
        for (Map.Entry<String, Collection<ValidationError>> error : validationErrors.entrySet()) {
            String errorDescription = error.getValue().stream().map(ValidationError::toValidationErrorsOverviewString).collect(Collectors.joining(", "));
            stringBuilder.append("Incorrect value is pointed out by the expression '").append(error.getKey()).append("' and is related to the following error message '").append(errorDescription).append("'. ");
        }
        return stringBuilder.toString();
    }

    private String describeValidationErrors(String uniqueToken, ValidationErrors rolesErrors, ValidationErrors rolesMappingErrors) {
        Map rolesErrorsMap = Optional.ofNullable(rolesErrors).filter(ValidationErrors::hasErrors).map(ValidationErrors::getErrors).orElseGet(Collections::emptyMap);
        Map mappingsErrorsMap = Optional.ofNullable(rolesMappingErrors).filter(ValidationErrors::hasErrors).map(ValidationErrors::getErrors).orElseGet(Collections::emptyMap);
        if (!rolesErrorsMap.isEmpty() || !mappingsErrorsMap.isEmpty()) {
            String rolesErrorDescription = DlsFlsProcessedConfig.describeConfigurationErrors(rolesErrorsMap, "roles");
            String mappingsErrorDescription = DlsFlsProcessedConfig.describeConfigurationErrors(mappingsErrorsMap, "roles mapping");
            String message = rolesErrorDescription + mappingsErrorDescription + "Please correct the configuration to unblock access to the system. (" + uniqueToken + ")";
            log.error(message);
            return message;
        }
        return null;
    }

    public String getValidationErrorDescription() {
        return this.validationErrorDescription;
    }

    public String getUniqueValidationErrorToken() {
        return this.uniqueValidationErrorToken;
    }
}

